<?php
/*
Plugin Name: Burst Instagram Feed
Description: Plugin that adds Instagram feed functionality to our theme
Author: Mikado Themes
Version: 2.0
*/

define('BURST_INSTAGRAM_FEED_VERSION', '2.0');
define('BURST_INSTAGRAM_ABS_PATH', dirname(__FILE__));
define('BURST_INSTAGRAM_REL_PATH', dirname(plugin_basename(__FILE__ )));
define( 'BURST_INSTAGRAM_URL_PATH', plugin_dir_url( __FILE__ ) );
define( 'BURST_INSTAGRAM_ASSETS_PATH', BURST_INSTAGRAM_ABS_PATH . '/assets' );
define( 'BURST_INSTAGRAM_ASSETS_URL_PATH', BURST_INSTAGRAM_URL_PATH . 'assets' );
define( 'BURST_INSTAGRAM_SHORTCODES_PATH', BURST_INSTAGRAM_ABS_PATH . '/shortcodes' );
define( 'BURST_INSTAGRAM_SHORTCODES_URL_PATH', BURST_INSTAGRAM_URL_PATH . 'shortcodes' );

include_once 'load.php';

if ( ! function_exists( 'burst_instagram_theme_installed' ) ) {
    /**
     * Checks whether theme is installed or not
     * @return bool
     */
    function burst_instagram_theme_installed() {
        return defined( 'BURST_MIKADO' );
    }
}

if ( ! function_exists( 'burst_instagram_feed_text_domain' ) ) {
	/**
	 * Loads plugin text domain so it can be used in translation
	 */
	function burst_instagram_feed_text_domain() {
		load_plugin_textdomain( 'burst-instagram-feed', false, BURST_INSTAGRAM_REL_PATH . '/languages' );
	}
	
	add_action( 'plugins_loaded', 'burst_instagram_feed_text_domain' );
}