<?php

if(!function_exists('mikado_core_ajax_meta')) {
    /**
     * Function that echoes meta data for ajax
     *
     * @since 4.3
     * @version 0.2
     */
    function mikado_core_ajax_meta() {
        global $burst_mikado_options;

        $seo_description = get_post_meta(burst_mikado_get_page_id(), "mkd_seo_description", true);
        $seo_keywords = get_post_meta(burst_mikado_get_page_id(), "mkd_seo_keywords", true);
        ?>

        <div class="seo_title"><?php wp_title('|', true, 'right'); ?></div>

        <?php if($seo_description !== ''){ ?>
            <div class="seo_description"><?php echo esc_html($seo_description); ?></div>
        <?php } else if($burst_mikado_options['meta_description']){?>
            <div class="seo_description"><?php echo esc_html($burst_mikado_options['meta_description']); ?></div>
        <?php } ?>
        <?php if($seo_keywords !== ''){ ?>
            <div class="seo_keywords"><?php echo esc_html($seo_keywords); ?></div>
        <?php }else if($burst_mikado_options['meta_keywords']){?>
            <div class="seo_keywords"><?php echo esc_html($burst_mikado_options['meta_keywords']); ?></div>
        <?php }
    }

    add_action('burst_mikado_ajax_meta', 'mikado_core_ajax_meta');
}

if(!function_exists('mikado_core_header_meta')) {
    /**
     * Function that echoes meta data if our seo is enabled
     */
    function mikado_core_header_meta() {
        global $burst_mikado_options;

        if(burst_mikado_is_seo_enabled() && !burst_mikado_seo_plugin_installed()) {
            $seo_description = get_post_meta(burst_mikado_get_page_id(), "mkd_seo_description", true);
            $seo_keywords = get_post_meta(burst_mikado_get_page_id(), "mkd_seo_keywords", true);
            ?>

            <?php if($seo_description) { ?>
                <meta name="description" content="<?php echo esc_html($seo_description); ?>">
            <?php } else if($burst_mikado_options['meta_description']){ ?>
                <meta name="description" content="<?php echo esc_html($burst_mikado_options['meta_description']) ?>">
            <?php } ?>

            <?php if($seo_keywords) { ?>
                <meta name="keywords" content="<?php echo esc_html($seo_keywords); ?>">
            <?php } else if($burst_mikado_options['meta_keywords']){ ?>
                <meta name="keywords" content="<?php echo esc_html($burst_mikado_options['meta_keywords']) ?>">
            <?php }
        }

        if(burst_mikado_is_ios_format_detection_disabled()){ ?>
            <meta name="format-detection" content="telephone=no">
        <?php } ?>

        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <?php
        if (isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false))
            echo('<meta content="IE=edge,chrome=1" http-equiv="X-UA-Compatible">');
        ?>

        <link rel="profile" href="http://gmpg.org/xfn/11" />
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
        <?php if(!function_exists( 'has_site_icon' ) || !has_site_icon()) { ?>
            <link rel="shortcut icon" type="image/x-icon" href="<?php echo esc_url($burst_mikado_options['favicon_image']); ?>">
            <link rel="apple-touch-icon" href="<?php echo esc_url($burst_mikado_options['favicon_image']); ?>"/>
        <?php } ?>
    <?php }

    add_action('burst_mikado_header_meta', 'mikado_core_header_meta');
}

if(!function_exists('mikado_core_user_scalable_meta')) {
    /**
     * Function that outputs user scalable meta if responsiveness is turned on
     * Hooked to burst_mikado_header_meta action
     */
    function mikado_core_user_scalable_meta() {
        //is responsiveness option is chosen?
        if (burst_mikado_is_responsive_on()) { ?>
            <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no">
        <?php }	else { ?>
            <meta name="viewport" content="width=1200,user-scalable=no">
        <?php }
    }

    add_action('burst_mikado_header_meta', 'mikado_core_user_scalable_meta');
}

if(!function_exists('mikado_core_is_ajax')) {
    /**
     * Function that checks if current request is ajax request
     * @return bool whether it's ajax request or not
     *
     * @version 0.1
     */
    function mikado_core_is_ajax() {
        return !empty( $_SERVER[ 'HTTP_X_REQUESTED_WITH' ]) && strtolower( $_SERVER[ 'HTTP_X_REQUESTED_WITH' ]) == 'xmlhttprequest';
    }
}

if(!function_exists('mikado_core_remove_yoast_json_on_ajax')) {
    /**
     * Function that removes yoast json ld script
     * that stops page transition to work on home page
     * Hooks to wpseo_json_ld_output in order to disable json ld script
     * @return bool
     *
     * @param $data array json ld data that is being passed to filter
     *
     * @version 0.2
     */
    function mikado_core_remove_yoast_json_on_ajax($data) {
        //is current request made through ajax?
        if(mikado_core_is_ajax()) {
            //disable json ld script
            return array();
        }

        return $data;
    }

    //is yoast installed and it's version is greater or equal of 1.6?
    if(defined('WPSEO_VERSION') && version_compare(WPSEO_VERSION, '1.6') >= 0) {
        add_filter('wpseo_json_ld_output', 'mikado_core_remove_yoast_json_on_ajax');
    }
}

if( ! function_exists('mikado_core_add_inline_html_after_content') ){
    function mikado_core_add_inline_html_after_content(){
        $burst_mikado_options = burst_mikado_return_global_options();
        $id = burst_mikado_get_page_id();
        $animation = get_post_meta($id, "mkd_show-animation", true);

        if($burst_mikado_options['page_transitions'] == "1" || $burst_mikado_options['page_transitions'] == "2" || $burst_mikado_options['page_transitions'] == "3" || $burst_mikado_options['page_transitions'] == "4" || ($animation == "updown") || ($animation == "fade") || ($animation == "updown_fade") || ($animation == "leftright")){ ?>
            <div class="meta">
                <?php do_action('burst_mikado_ajax_meta'); ?>
                <span id="mkd_page_id"><?php echo esc_html( burst_mikado_get_page_id() ); ?></span>
                <div class="body_classes"><?php echo esc_html(implode( ',', get_body_class())); ?></div>
            </div>
        <?php }
    }

    add_action( 'burst_mikado_after_content_begin', 'mikado_core_add_inline_html_after_content' );
}

if ( ! function_exists( 'mikado_core_add_content_classes' ) ) {
    function mikado_core_add_content_classes( $classes ) {

        $burst_mikado_options = burst_mikado_return_global_options();
        $id = burst_mikado_get_page_id();
        extract(burst_mikado_get_header_variables());

        $is_title_area_visible = true;
        if(get_post_meta($id, "mkd_show-page-title", true) == 'yes') {
            $is_title_area_visible = true;
        } elseif(get_post_meta($id, "mkd_show-page-title", true) == 'no') {
            $is_title_area_visible = false;
        } elseif(get_post_meta($id, "mkd_show-page-title", true) == '' && (isset($burst_mikado_options['show_page_title']) && $burst_mikado_options['show_page_title'] == 'yes')) {
            $is_title_area_visible = true;
        } elseif(get_post_meta($id, "mkd_show-page-title", true) == '' && (isset($burst_mikado_options['show_page_title']) && $burst_mikado_options['show_page_title'] == 'no')) {
            $is_title_area_visible = false;
        } elseif(isset($burst_mikado_options['show_page_title']) && $burst_mikado_options['show_page_title'] == 'yes') {
            $is_title_area_visible = true;
        }
        if((get_post_meta($id, "mkd_revolution-slider", true) == "" && ($header_transparency == '' || $header_transparency == 1))  || get_post_meta($id, "mkd_enable_content_top_margin", true) == "yes" ){
            if($burst_mikado_options['header_bottom_appearance'] == "fixed" || $burst_mikado_options['header_bottom_appearance'] == "fixed_hiding" || $burst_mikado_options['header_bottom_appearance'] == "fixed fixed_minimal"){
                $classes .= " content_top_margin";
            }else {
                $classes .= " content_top_margin_none";
            }
        }

        if(isset($burst_mikado_options['header_bottom_appearance']) && ($burst_mikado_options['header_bottom_appearance'] == "stick" || $burst_mikado_options['header_bottom_appearance'] == "stick menu_bottom" || $burst_mikado_options['header_bottom_appearance'] == "stick_with_left_right_menu" || $burst_mikado_options['header_bottom_appearance'] == "stick compound")){
            if(get_post_meta(burst_mikado_get_page_id(), "mkd_page_hide_initial_sticky", true) !== ''){
                if(get_post_meta(burst_mikado_get_page_id(), "mkd_page_hide_initial_sticky", true) == 'yes'){
                    $classes = "content";
                }
            }else if(isset($burst_mikado_options['hide_initial_sticky']) && $burst_mikado_options['hide_initial_sticky'] == 'yes') {
                $classes = "content";
            }
        }


        if(burst_mikado_get_page_template_name() == "full_screen"){
            // solution for top header
            if(!burst_mikado_is_side_header()){
                if (($header_transparency == '' || $header_transparency == 1) || ($burst_mikado_options['header_bottom_appearance'] == "regular" || $burst_mikado_options['header_bottom_appearance'] == "fixed_top_header")) {
                    if ($burst_mikado_options['header_bottom_appearance'] == "fixed" || $burst_mikado_options['header_bottom_appearance'] == "fixed_hiding" || $burst_mikado_options['header_bottom_appearance'] == "fixed fixed_minimal") {
                        $classes .= " content_top_margin_none";
                    }
                    elseif($burst_mikado_options['header_bottom_appearance'] == 'stick menu_bottom'){
                        $classes .= "content"; // delete class if exists
                    }
                    else {
                        $classes .= " content_top_margin_negative content_top_margin_none";
                    }
                }
            }

            // solution for paspartu on side and top header
            if((isset($burst_mikado_options['paspartu']) && $burst_mikado_options['paspartu'] == 'yes') && (isset($burst_mikado_options['paspartu_on_top']) && $burst_mikado_options['paspartu_on_top'] == 'yes')){
                if(isset($burst_mikado_options['paspartu_on_top_fixed']) && $burst_mikado_options['paspartu_on_top_fixed'] == 'yes'){
                    if(!(burst_mikado_is_side_header() && (isset($burst_mikado_options['vertical_menu_inside_paspartu']) && $burst_mikado_options['vertical_menu_inside_paspartu'] == 'yes'))){ // not for this case
                        $classes .= " content_top_margin_vm_paspartu";
                    }
                }
                else{
                    // not resolved
                }
            }
        }

        //check if there is slider added and set class to content div, this is used for content top margin in style_dynamic.php
        if(get_post_meta($id, "mkd_revolution-slider", true) != ""){
            $classes .= " has_slider";
        }

        return $classes;
    }

    add_filter( 'burst_mikado_content_classes', 'mikado_core_add_content_classes' );
}

if( ! function_exists('mikado_core_add_visual_composer_custom_shortcodce_css') ){
    function mikado_core_add_visual_composer_custom_shortcodce_css(){

        $burst_mikado_options = burst_mikado_return_global_options();
        $id = burst_mikado_get_page_id();
        $animation = get_post_meta($id, "mkd_show-animation", true);

        if($burst_mikado_options['page_transitions'] == "1" || $burst_mikado_options['page_transitions'] == "2" || $burst_mikado_options['page_transitions'] == "3" || $burst_mikado_options['page_transitions'] == "4" || ($animation == "updown") || ($animation == "fade") || ($animation == "updown_fade") || ($animation == "leftright")){
            do_action('burst_mikado_visual_composer_custom_shortcodce_css');
        }

    }

    add_action('burst_mikado_after_content_inner_begin', 'mikado_core_add_visual_composer_custom_shortcodce_css');
}

if ( ! function_exists( 'mikado_core_add_content_classes' ) ) {
    function mikado_core_add_content_classes( $classes ) {
        $id = burst_mikado_get_page_id();
        $animation = get_post_meta($id, "mkd_show-animation", true);

        $classes .= $animation;

        return $classes;
    }

    add_filter( 'burst_mikado_content_classes', 'mikado_core_add_content_classes' );
}

if(!function_exists('burst_mikado_visual_composer_custom_shortcodce_css')) {
    /**
     * Function that adds Visual composer's custom css to our action. Needed for ajax page transitions
     */
    function burst_mikado_visual_composer_custom_shortcodce_css() {
        if(burst_mikado_visual_composer_installed()) {
            if(is_page() || is_single() || is_singular('portfolio_page')) {

                $shortcodes_custom_css = get_post_meta( burst_mikado_get_page_id(), '_wpb_shortcodes_custom_css', true );
                if ( ! empty( $shortcodes_custom_css ) ) {
                    echo '<style type="text/css" data-type="vc_shortcodes-custom-css-'.esc_attr(burst_mikado_get_page_id()).'" scoped>';
                    echo get_post_meta( burst_mikado_get_page_id(), '_wpb_shortcodes_custom_css', true );
                    echo '</style>';
                }

                $post_custom_css = get_post_meta( burst_mikado_get_page_id(), '_wpb_post_custom_css', true );
                if ( ! empty( $post_custom_css ) ) {
                    echo '<style type="text/css" data-type="vc_custom-css-'.esc_attr(burst_mikado_get_page_id()).'" scoped>';
                    echo get_post_meta( burst_mikado_get_page_id(), '_wpb_post_custom_css', true );
                    echo '</style>';
                }
            }
        }
    }

    add_action('burst_mikado_visual_composer_custom_shortcodce_css', 'burst_mikado_visual_composer_custom_shortcodce_css');
}